DECLARE SUB OptionSetUp ()
DECLARE SUB OptionsWindow (startrow%, startcolumn%, length%, girth%)
DECLARE SUB OptionsText ()
DECLARE SUB OptionsCommandLine ()
DEFINT A-Z
DECLARE SUB MakeDatFile ()
DECLARE SUB SaveScreenDisplay ()
DECLARE SUB SaveLineOn ()
DECLARE SUB SetColors ()
DECLARE SUB ColorScreenWindow (startrow, startcolumn, length, girth)
DECLARE SUB Cursor (old, new, startrow, startcolumn)
DECLARE SUB DisplayCursorsLnR ()
DECLARE SUB MoveVerticalBar (old, new)
DECLARE SUB ScreenSetup ()
DECLARE SUB QuitPrompt (r, col)
DECLARE SUB RestoreCommandScreen ()
DECLARE SUB RestoreTerminalScreen ()
DECLARE SUB SaveCommandScreen ()
DECLARE SUB SaveTerminalScreen ()
DECLARE SUB TerminalLineOn ()
DECLARE SUB TerminalLineOff ()
DECLARE SUB SaveFileScreen ()
DECLARE SUB RestoreFileScreen ()
DECLARE SUB OpenWindow (startrow%, startcolumn%, Rows%, Columns%)
DECLARE SUB SplitPrint ()
DECLARE SUB TerminalHelp ()
DECLARE SUB DisplayFile (Filename$)
DECLARE SUB SaveScreen ()
DECLARE SUB RestoreScreen ()
DECLARE SUB Initialize ()
DECLARE SUB FileLineOff ()
DECLARE SUB SplitScreen ()
DECLARE SUB PromptLineOn (row, column)
DECLARE SUB PromptLineOff (row, column)
DECLARE SUB RS232 ()
DECLARE SUB GetInstruction (Count, Instruction$, Filename$)
DECLARE SUB OpenFile (Count, Filename$)
DECLARE SUB File ()
DECLARE SUB GetKey (Key$)
DECLARE SUB SetBaud ()
DECLARE SUB GetString (Key$, InputString$, limit)
DECLARE SUB TERMINAL ()
DECLARE SUB TerminalScreen ()
DECLARE SUB FileLineOn ()
DECLARE SUB CommandLineHelp ()
DECLARE SUB SetDate ()
DECLARE SUB SetTime ()
DECLARE SUB CommandLineOff ()
DECLARE SUB FileHelp ()
DECLARE SUB SendInstruction (Count, Filename$, Instruction$)
DECLARE SUB CommandLineOn ()
DECLARE SUB BackUp (InputString$, Key$, limit)

COMMON SHARED quit$, CarriageReturn$, BackSpace$, CursorRight$, CursorLeft$
COMMON SHARED LineFeed$, CursorUp$, CursorDown$, Blank$, repeat$, SplitChar$
COMMON SHARED Tab$, Baud$, ComPort$
COMMON SHARED Switch, FileError, ScreenMode, Split, ComPort
COMMON SHARED StartLine, EndLine
COMMON SHARED Foreground, Background, Border, VerticalBar
COMMON SHARED CommandLineBackground, CommandLineText, CommandLineBold
COMMON SHARED PromptLineBackground, PromptLineText
COMMON SHARED WindowText, WindowBackground
COMMON SHARED RS232File, InstructionFile, ParameterFile

DIM SHARED FileScreenbuffer(8000 TO 11999) AS INTEGER
DIM SHARED TerminalScreenbuffer(4000 TO 7999) AS INTEGER
DIM SHARED CommandScreenbuffer(12000 TO 15999) AS INTEGER
DIM SHARED ScreenBuffer(1 TO 25, 1 TO 80) AS INTEGER
DIM SHARED ColorPalette(0 TO 10) AS INTEGER

'FileError = 0

DATA 4, 8, 15, 7, 1, 8, 7, 7, 0, 7, 1
DATA "COM2:", "1200"
DATA  51

'screen/keyboard characters
	quit$ = (CHR$(0) + CHR$(16))                '<Alt>Q
	CarriageReturn$ = CHR$(13)
	LineFeed$ = CHR$(10)
	BackSpace$ = CHR$(8)
	Tab$ = CHR$(9)
	CursorRight$ = CHR$(0) + CHR$(77)
	CursorLeft$ = CHR$(0) + CHR$(75)
	CursorUp$ = CHR$(0) + CHR$(72)
	CursorDown$ = CHR$(0) + CHR$(80)
	Blank$ = CHR$(32)
	repeat$ = CHR$(0) + CHR$(19)                                  '<Alt>R
	SplitChar$ = CHR$(177)

'Screen co-ordinates:
	StartLine = 2
	EndLine = 24
	'Split = 51


Restart:
    'CLEAR
    CALL Initialize
    CALL SetBaud       'SIGN-ON, SET BAUD, OPEN COM PORT
    CALL SetDate
    CALL SetTime
    LINE INPUT " press any key to continue .."; Junk$
DO
    ScreenMode = 3
    SCREEN 0, 1, ScreenMode, ScreenMode
    CALL PromptLineOn(r, c)
    CALL PromptLineOff(r, c)
    LOCATE r, c
    CALL CommandLineOn
    CALL SplitScreen
    IF Switch THEN
	Key$ = Switch$
	Switch = 0
    ELSE
	CALL GetKey(Key$)
    END IF
    SELECT CASE Key$
	CASE IS = "T"
		CALL TERMINAL
	CASE IS = "F"
		File
	CASE IS = "B"
		CALL CommandLineOff
		CALL SetBaud
	CASE IS = "O"
		CALL OptionSetUp
	CASE IS = "H"
		CALL CommandLineHelp
	CASE IS = "S"
		CALL ScreenSetup
	CASE IS = quit$
		CALL PromptLineOn(r, c)
		PRINT " press <Esc> again to confirm exit";
		CALL GetKey(Key$)
		IF Key$ = quit$ THEN
			CLOSE
			EXIT DO
		END IF
	CASE ELSE
		BEEP
    END SELECT
LOOP
END


'RS232 Receiver
Receiver: CALL RS232
	  RETURN


Help:   KEY(1) OFF
	IF ScreenMode = 3 THEN
		CALL CommandLineHelp
	ELSEIF ScreenMode = 2 THEN
		CALL FileHelp
	ELSEIF ScreenMode = 1 THEN
		CALL TerminalHelp
	END IF
	KEY(1) ON
	RETURN


Switchtrap:
	KEY(6) OFF
	IF ScreenMode = 1 THEN
		Switch = 1
		Switch$ = "F"                               'terminal -> file
	ELSEIF ScreenMode = 2 THEN
		Switch = 1
		Switch$ = "T"                               'file -> terminal
	END IF
	KEY(6) ON
	RETURN


ErrorTrap:                                            'ERROR TRAPPING ROUTINE
     BEEP
     Fatal = 0
     CALL PromptLineOn(ErrorRow, ErrorColumn)
     SELECT CASE ERR
	CASE 5
		Errormessage$ = "illegal function call"
	CASE 24 'device timeout
		FileError = ERR
		CALL PromptLineOff(ErrorRow, ErrorColumn)
		RESUME NEXT
	CASE 52 'bad file number
		Errormessage$ = "file not open"
		FileError = ERR
	CASE 53 'file not found
		Errormessage$ = "file not found"
		FileError = ERR
	CASE 57 'device I/O error
		Errormessage$ = "device I/O error"
		Fatal = 1
	CASE 62 'bad filename
		Errormessage$ = "input past end of file"
		FileError = ERR
	CASE 64 'bad filename
		Errormessage$ = "illegal filename"
		FileError = ERR
	CASE 75 'path/file access error
		Errormessage$ = "path to filename not found"
		FileError = ERR
	CASE 76 'path not found
		Errormessage$ = "path not found"
		FileError = ERR
	CASE ELSE
		Errormessage$ = "ERROR NUMBER " + STR$(ERR)
     END SELECT
     PRINT : PRINT Errormessage$;
     PRINT ".. press any key to continue";
     CALL GetKey(Key$)
     CALL PromptLineOff(ErrorRow, ErrorColumn)
     IF Fatal THEN
	GOTO Restart
     ELSEIF Key$ = quit$ THEN
	GOTO Restart
     ELSE
	RESUME NEXT
     END IF
     RESUME

SUB BackUp (InputString$, Key$, limit)
       column = POS(X) - 1
       IF column < limit THEN column = limit
       LOCATE , column
       PRINT " ";
       LOCATE , column
       IF column > limit THEN
	  length = LEN(InputString$) - 1
	  InputString$ = MID$(InputString$, 1, length)
       ELSE
	  InputString$ = ""
       END IF
       Key$ = ""
END SUB

SUB ColorScreenWindow (startrow, startcolumn, length, girth)
	CALL OpenWindow(startrow, startcolumn, length, girth)
	LOCATE startrow + 1, startcolumn + 4
	PRINT "COMMAND LINE HI-LITE    "; CommandLineBold;
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "COMMAND LINE TEXT       "; CommandLineText;
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "COMMAND LINE BACKGROUND "; CommandLineBackground;
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "FOREGROUND              "; Foreground;
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "BACKGROUND              "; Background;
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "WINDOW TEXT             "; WindowText;
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "WINDOW BACKGROUND       "; WindowBackground;
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "VERTICAL BAR            "; VerticalBar;
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "PROMPT LINE TEXT        "; PromptLineText;
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "PROMPT LINE BACKGROUND  "; PromptLineBackground;
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "BORDER                  "; Border;
END SUB

SUB CommandLineHelp
	CALL SaveCommandScreen
	column = POS(0)
	row = CSRLIN
	startrow = 6
	startcolumn = 5
	length = 16
	girth = 69
	CALL CommandLineOff
	VIEW PRINT StartLine TO EndLine
	COLOR Foreground, Background, Border
	CALL OpenWindow(startrow, startcolumn, length, girth)
	LOCATE startrow + 2, startcolumn + 4
	PRINT "   The RUN170 program enables the user to control the Centent";
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "CN0170 motion controller with any PC. Seperate screens are";
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "provided for operation from the keyboard (TERMINAL) or from a";
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "file stored on disk. When running from a file it is possible";
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "to single step or send the instructions continuously.";
	LOCATE CSRLIN + 2, startcolumn + 4
	PRINT "   The baud rate or Comm port # may be changed with the Baud";
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "command. Be sure to reset the CN0170 (power-down) first.";
	LOCATE CSRLIN + 2, startcolumn + 4
	PRINT "   Any changes for baud, Comm port or screen colors will be";
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "saved in a file named RUN170.DAT. If this file is unavailable";
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "on start up, the program will use default parameters and";
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "create the RUN170.DAT file.";
       
	CALL QuitPrompt(r, col)
	LOCATE row, column
	CALL RestoreCommandScreen
END SUB

SUB CommandLineOff
	column = POS(0)
	row = CSRLIN
	VIEW PRINT 1 TO 1
	COLOR CommandLineText, CommandLineBackground: PRINT "    ";
	PRINT "Terminal    ";
	PRINT "File    ";
	PRINT "Baud rate    ";
	PRINT "Options    ";
       
	PRINT "Screen     ";
	PRINT "F1=Help     ";
	PRINT "<Esc>    ";
	VIEW PRINT StartLine TO EndLine
	COLOR Foreground, Background, Border
	LOCATE row, column
END SUB

SUB CommandLineOn
    column = POS(0)
    row = CSRLIN
    VIEW PRINT 1 TO 1
    COLOR CommandLineBold, CommandLineBackground
    PRINT "    T"; : COLOR CommandLineText: PRINT "erminal    ";
    COLOR CommandLineBold
    PRINT "F"; : COLOR CommandLineText: PRINT "ile    ";
    COLOR CommandLineBold: PRINT "B"; : COLOR CommandLineText
    PRINT "aud rate    ";
    COLOR CommandLineBold: PRINT "O"; : COLOR CommandLineText
    PRINT "ptions    ";
    COLOR CommandLineBold
    PRINT "S"; : COLOR CommandLineText: PRINT "creen     ";
    COLOR CommandLineBold
    PRINT "F1"; : COLOR CommandLineText: PRINT "=Help     ";
    COLOR CommandLineBold: PRINT "<Esc>    ";
    VIEW PRINT StartLine TO EndLine
    COLOR Foreground, Background, Border
    LOCATE row, column
END SUB

SUB Cursor (old, new, startrow, startcolumn)
	COLOR WindowText, WindowBackground
	row = CSRLIN
	column = POS(0)
	LOCATE old + startrow + 1, startcolumn + 1
	PRINT "  ";
	LOCATE new + startrow + 1, startcolumn + 1
	PRINT CHR$(205); CHR$(16);
	LOCATE row, column
END SUB

SUB DisplayCursorsLnR
	CALL PromptLineOn(r, c)
	PRINT " press <Esc> to quit";
	LOCATE , Split - 1
	PRINT CHR$(17); "-"; CHR$(16);
	'LOCATE , Split
	'PRINT CHR$(29);
END SUB

SUB DisplayFile (Filename$)
	column = POS(0)
	row = CSRLIN
	CALL PromptLineOn(row, column)
	PRINT
	IF PromptLineText = 7 THEN
		COLOR 8
	ELSE
		COLOR PromptLineText + 8
	END IF
	PRINT " "; Filename$;
	COLOR Foreground
	CALL FileLineOn
	LOCATE row, column
END SUB

SUB File
  STATIC Count, row, column, Filename$, Instruction$
   
  ScreenMode = 2
  SCREEN 0, 1, ScreenMode, ScreenMode                                   '**
  IF row < 2 THEN row = 2
  IF column < 1 THEN column = 1
  LOCATE row, column
  DO
    CALL DisplayFile(Filename$)
    CALL SplitScreen
    CALL GetKey(Key$)
    SELECT CASE Key$
	CASE IS = "O"                                             'Open File
		CALL OpenFile(Count, Filename$)
		IF Filename$ = "" THEN EXIT DO
		CALL GetInstruction(Count, Instruction$, Filename$)
	CASE IS = CarriageReturn$                      'send one instruction
		CALL SendInstruction(Count, Filename$, Instruction$)
		CALL GetInstruction(Count, Instruction$, Filename$)
	CASE IS = "G"                                  'go to end of program
		CALL PromptLineOn(row, column)
		PRINT " press any key to interrupt operation";
		CALL FileLineOff
		DO
		     CALL SendInstruction(Count, Filename$, Instruction$)
		     IF FileError THEN
			FileError = 0
			EXIT DO
		     END IF
		     CALL GetInstruction(Count, Instruction$, Filename$)
		LOOP WHILE NOT EOF(InstructionFile) AND INKEY$ = ""
		CALL PromptLineOn(row, column)                          '**
		PRINT
		CALL FileLineOn
		IF EOF(InstructionFile) THEN
			CALL SendInstruction(Count, Filename$, Instruction$)
			CALL SplitScreen
			CALL OpenFile(Count, Filename$)
			CALL GetInstruction(Count, Instruction$, Filename$)
		END IF
	CASE IS = " "                                  'skip one instruction
		IF EOF(InstructionFile) THEN CALL OpenFile(Count, Filename$)
		CALL GetInstruction(Count, Instruction$, Filename$)
	CASE IS = quit$
		EXIT DO
	CASE ELSE
		IF INSTR("0123456789", Key$) <> 0 THEN
		   LoopCount$ = Key$
		   CALL FileLineOff
		   CALL PromptLineOn(row, column)
		   PRINT " enter # of instructions to send -> "; Key$;
		   DO
		     CALL GetKey(Key$)
		     SELECT CASE Key$
		       CASE quit$
			    EXIT DO
		       CASE BackSpace$
			    CALL BackUp(LoopCount$, Key$, limit)
		       CASE LeftArrow$
			    CALL BackUp(LoopCount$, Key$, limit)
		       CASE CarriageReturn$
		      
		       CASE ELSE
			    IF INSTR("0123456789", Key$) <> 0 THEN
				LoopCount$ = LoopCount$ + Key$
				PRINT Key$;
			    ELSE
				BEEP
			    END IF
		     END SELECT
		   LOOP UNTIL Key$ = CarriageReturn$
		   PRINT
		   CALL FileLineOn
		   LoopCount = VAL(LoopCount$)
		   CALL PromptLineOn(row, column)
		   PRINT " press any key to interrupt operation";
		   CALL FileLineOff
		   FOR n = 1 TO LoopCount
			IF EOF(InstructionFile) OR (INKEY$ <> "") THEN
				n = LoopCount
			END IF
			CALL SendInstruction(Count, Filename$, Instruction$)
			CALL GetInstruction(Count, Instruction$, Filename$)
		   NEXT n
		   CALL PromptLineOn(row, column)
		   PRINT
		   CALL FileLineOn
		ELSE
			BEEP
		END IF
    END SELECT
  LOOP
  Key$ = ""
  column = POS(0)
  row = CSRLIN
END SUB

SUB FileHelp
	column = POS(0)
	row = CSRLIN
	CALL SaveScreen
	'CALL FileLineOff
	startrow = 3
	startcolumn = 15
	CALL OpenWindow(startrow, startcolumn, 19, 65)
	LOCATE startrow + 2, startcolumn + 4
	PRINT "<Open>   open file for downloading to CN0170";
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "         include path if not in the current directory";
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "         use backspace or <Ctrl>H to edit filename";
	LOCATE CSRLIN + 2, startcolumn + 4
	PRINT "<Go>     to download entire file. Press any key to stop;";
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "         and wait for futher input";
	LOCATE CSRLIN + 2, startcolumn + 4
	PRINT "<0-9>    enter the number (to 4 digits) of lines to do.";
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "         the line numbers are provided for reference;";
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "         they are not from the source file.";
	LOCATE CSRLIN + 2, startcolumn + 4
	PRINT "<ENTER>  to send a single instruction to the CN0170";
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "<SPACE>  press the space bar to skip the instruction";
	LOCATE CSRLIN + 2, startcolumn + 4
	PRINT "<F6>     switches from FILE to TERMINAL directly";
	CALL QuitPrompt(r, col)
	CALL RestoreScreen
	LOCATE row, column
END SUB

SUB FileLineOff
	column = POS(0)
	row = CSRLIN
	VIEW PRINT 1 TO 1
	LOCATE 1
	COLOR CommandLineText, CommandLineBackground
	PRINT "    Open    Go   <0-9>   <ENTER>    <SPACE>    F6=Switch    ";
	PRINT "F1=Help    ";
	COLOR CommandLineBold
	PRINT "<Esc>    ";
	VIEW PRINT StartLine TO EndLine
	COLOR Foreground, Background, Border
	LOCATE row, column
END SUB

SUB FileLineOn
	column = POS(0)
	row = CSRLIN
	VIEW PRINT 1 TO 1
	COLOR CommandLineBold, CommandLineBackground
	PRINT "    O";
	COLOR CommandLineText
	PRINT "pen    ";
	COLOR CommandLineBold
	PRINT "G";
	COLOR CommandLineText
	PRINT "o   ";
	COLOR CommandLineBold
	PRINT "<0-9>   <ENTER>    <SPACE>    F6";
	COLOR CommandLineText
	PRINT "=Switch    ";
	COLOR CommandLineBold
	PRINT "F1";
	COLOR CommandLineText
	PRINT "=Help    ";
	COLOR CommandLineBold
	PRINT "<Esc>    ";
	VIEW PRINT StartLine TO EndLine
	COLOR Foreground, Background, Border
	LOCATE row, column
END SUB

SUB GetInstruction (Count, Instruction$, Filename$)
	IF EOF(InstructionFile) THEN CALL OpenFile(Count, Filename$)
	LINE INPUT #InstructionFile, Instruction$
	IF FileError THEN CALL OpenFile(Count, Filename$)
	IF NOT FileError THEN
	   CALL SplitPrint
	   PRINT                                                        '#6
	   CALL SplitPrint
	   IF LEN(Instruction$) > (Split - 7) THEN
	      PRINT Count; " ";
	      column = POS(0)
	      PRINT LEFT$(Instruction$, (Split - 7))                    '#7
	      LOCATE , column
	      PRINT RIGHT$(Instruction$, LEN(Instruction$) - (Split - 7));
	      CALL SplitPrint
	   ELSE
	      PRINT Count; " "; Instruction$;
	      CALL SplitPrint
	   END IF
	   Count = Count + 1
	END IF
END SUB

SUB GetKey (Key$)
	DO
		Key$ = INKEY$
		IF Switch THEN
			Key$ = quit$
			EXIT DO
		END IF
	LOOP WHILE Key$ = ""
	IF ASC(Key$) <> 0 THEN Key$ = UCASE$(Key$)
	IF Key$ = CHR$(27) THEN Key$ = quit$            'Esc is same as AltQ
END SUB

SUB GetString (Key$, InputString$, limit)
       LOCATE , , 1
       temp$ = InputString$
       InputString$ = "" + Key$
       DO
	 PRINT Key$;                       'DISPLAY KEY ON SCREEN
	 IF Key$ = CarriageReturn$ THEN EXIT DO
	 CALL GetKey(Key$)
	 IF Key$ = quit$ THEN
		EXIT DO
	 ELSEIF (Key$ = BackSpace$) OR (Key$ = LeftArrow$) THEN
		CALL BackUp(InputString$, Key$, limit)
	 ELSEIF Key$ = repeat$ THEN
		InputString$ = temp$
		PRINT                                                   '#8
		EXIT DO
	 END IF
	 InputString$ = InputString$ + Key$   'ADD TO INPUTSTRING
       LOOP
END SUB

SUB Initialize
	WIDTH 80
	CLOSE
       
	ParameterFile = FREEFILE
	OPEN "RUN170.DAT" FOR RANDOM AS ParameterFile LEN = 12
	FOR n = 0 TO 10
		GET ParameterFile, n + 1, ColorPalette(n)
		IF EOF(ParameterFile) THEN CALL MakeDatFile
	NEXT n
	GET ParameterFile, 12, ComPort$
	IF EOF(ParameterFile) THEN CALL MakeDatFile
	GET ParameterFile, 13, Baud$
	IF EOF(ParameterFile) THEN CALL MakeDatFile
	GET ParameterFile, 14, Split
	IF EOF(ParameterFile) THEN CALL MakeDatFile
	CALL SetColors                               'assign colors to screen
	FOR i = 1 TO 3
		SCREEN 0, , i, i
		COLOR Foreground, Background, Border
		CLS
		LOCATE 25
		FOR n = 1 TO 25
			PRINT
		NEXT n
		LOCATE 1, 1
	NEXT i
	RS232File = FREEFILE
	InstructionFile = FREEFILE + 1
	ON ERROR GOTO ErrorTrap
	ON KEY(1) GOSUB Help
	ON KEY(6) GOSUB Switchtrap
	KEY(1) ON
	KEY(6) ON
END SUB

SUB MakeDatFile
	RESTORE
	FOR n = 0 TO 10
		READ ColorPalette(n)      'load color array from data
	NEXT n
	READ ComPort$, Baud$
	READ Split
	FOR n = 0 TO 10
		PUT ParameterFile, n + 1, ColorPalette(n)
	NEXT n
	PUT ParameterFile, 12, ComPort$
	PUT ParameterFile, 13, Baud$
	PUT ParameterFile, 14, Split
END SUB

SUB MoveVerticalBar (old, new)
	temp$ = SplitChar$
	SplitChar$ = " "
	Split = old
	CALL SplitScreen
	SplitChar$ = temp$
	Split = new
	CALL SplitScreen
END SUB

SUB OpenFile (Count, Filename$)
Of1:    CALL FileLineOff
	CALL SplitScreen
	CALL PromptLineOn(row, column)
	PRINT " Open file -> ";
	limit = POS(0)
	PRINT Filename$;
	DO
		CALL GetKey(Key$)
		SELECT CASE Key$
			CASE quit$
				PRINT
				Filename$ = ""
				EXIT SUB
			CASE CarriageReturn$
				EXIT DO
			CASE BackSpace$
				CALL BackUp(Filename$, Key$, limit)
			CASE LeftArrow$
				CALL BackUp(Filename$, Key$, limit)
			CASE ELSE
				PRINT Key$;       'DISPLAY KEY ON SCREEN
				Filename$ = Filename$ + Key$
		END SELECT
	LOOP
	CALL PromptLineOff(row, column)
	FileError = 0
	CLOSE InstructionFile
	OPEN Filename$ FOR INPUT AS InstructionFile
	Count = 1
	IF FileError GOTO Of1
	CALL DisplayFile(Filename$)
	PRINT STRING$(80, "-")
	CALL SplitScreen
END SUB

SUB OpenWindow (startrow, startcolumn, Rows, Columns)
	foregroundcolumn = POS(0)
	foregroundrow = CSRLIN
	EndRow = startrow + Rows - 1
	EndColumn = startcolumn + Columns - 1
	LOCATE startrow, startcolumn
	COLOR WindowText, WindowBackground
	PRINT CHR$(201);
	PRINT STRING$(EndColumn - startcolumn - 2, 205);
	PRINT CHR$(187);
	FOR row = startrow + 1 TO EndRow - 1
		LOCATE row, startcolumn
		PRINT CHR$(186);
		PRINT STRING$(EndColumn - startcolumn - 2, 32);
		PRINT CHR$(186);
	NEXT row
	LOCATE EndRow, startcolumn
	PRINT CHR$(200);
	PRINT STRING$(EndColumn - startcolumn - 2, 205);
	PRINT CHR$(188);
	LOCATE foregroundrow, foregroundcolumn
END SUB

SUB OptionsCommandLine
    column = POS(0)
    row = CSRLIN
    VIEW PRINT 1 TO 1
    COLOR CommandLineBold, CommandLineBackground
    PRINT "    "; CHR$(24); "    "; CHR$(25);
    COLOR CommandLineText: PRINT "    ";
    COLOR CommandLineBold
    PRINT "<Space>                       ";
    COLOR CommandLineBold: PRINT "                           <Esc>    ";
    VIEW PRINT StartLine TO EndLine
    COLOR Foreground, Background, Border
    LOCATE row, column
END SUB

SUB OptionSetUp
    oldBackground = Background
    oldForeground = Foreground
    oldsplit = Split
    startrow = 13
    startcolumn = 10
    length = 7
    girth = 36
    
    CALL OptionsText
    CALL OptionsWindow(startrow, startcolumn, length, girth)
    CALL PromptLineOn(r, c)
    PRINT " press <Esc> to quit";
    CALL OptionsCommandLine
    CALL Cursor(index, index, startrow, startcolumn)
    DO
      CALL GetKey(Key$)
      ExtendedCode = ASC(Key$)
      SELECT CASE Key$
	 CASE IS = "U"
	      IF ColorPalette(index) <= 14 THEN
		 ColorPalette(index) = ColorPalette(index) + 1
	      ELSE
		 ColorPalette(index) = 0
	      END IF
	      CALL SetColors
	      CALL SaveScreenDisplay
	      CALL ColorScreenWindow(startrow, startcolumn, length, girth)
	      CALL Cursor(index, index, startrow, startcolumn)
	 CASE IS = "D"
	      IF ColorPalette(index) >= 1 THEN
		 ColorPalette(index) = ColorPalette(index) - 1
	      ELSE
		 ColorPalette(index) = 15
	      END IF
	      CALL SetColors
	      CALL SaveScreenDisplay
	      CALL ColorScreenWindow(startrow, startcolumn, length, girth)
	      CALL Cursor(index, index, startrow, startcolumn)
	 CASE IS = CursorLeft$
	      COLOR Foreground, Background
	      CALL MoveVerticalBar(Split, Split - 1)
	      CALL DisplayCursorsLnR
	      CALL SaveLineOn
	 CASE IS = CursorRight$
	      COLOR Foreground, Background
	      CALL MoveVerticalBar(Split, Split + 1)
	      CALL DisplayCursorsLnR
	      CALL SaveLineOn
	 CASE IS = CursorDown$
	      IF index <= 3 THEN
		 index = index + 1
		 CALL Cursor(index - 1, index, startrow, startcolumn)
	      ELSE
		 index = 0
		 CALL Cursor(4, index, startrow, startcolumn)
	      END IF
	 CASE IS = CursorUp$
	      IF index >= 1 THEN
		 index = index - 1
		 CALL Cursor(index + 1, index, startrow, startcolumn)
	      ELSE
		 index = 4
		 CALL Cursor(0, index, startrow, startcolumn)
	      END IF
	 CASE IS = quit$
	      EXIT DO
	 CASE ELSE
	      BEEP
      END SELECT
    LOOP
    newsplit = Split
    FOR n = 1 TO 3
		SCREEN 0, 1, n, n
		COLOR Foreground, Background
		CALL MoveVerticalBar(oldsplit, newsplit)
    NEXT n
    FOR n = 0 TO 10
	PUT ParameterFile, n + 1, ColorPalette(n)
    NEXT n
    PUT ParameterFile, 14, Split
    FOR n = 1 TO 24
	PRINT
	CALL SplitScreen
    NEXT n
END SUB

SUB OptionsText
	COLOR Foreground, Background
	CLS
	CALL SplitScreen
	LOCATE 3, 1
	PRINT "   The INPUT FILE is the file to which input from the CN0170"
	PRINT " is written. To toggle the file ON/OFF press the spacebar. "
	PRINT
	PRINT "   The OUTPUT FILE is the file to which all keys pressed by"
	PRINT " you (TERMINAL screen) are recorded. To toggle the file "
	PRINT " ON/OFF press the spacebar"
	PRINT
	PRINT "   The BEEPER may be toggled ON/OFF with the spacebar"
	CALL SaveLineOn
END SUB

SUB OptionsWindow (startrow, startcolumn, length, girth)
	CALL OpenWindow(startrow, startcolumn, length, girth)
	LOCATE startrow + 1, startcolumn + 4
	PRINT "INPUT FILE   "; CommandLineBold;
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "  filename:  "; CommandLineText;
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "OUTPUT FILE  "; Foreground;
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "  filename:  "; Background;
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "BEEPER       "; WindowText;
       
	CALL SaveLineOn
END SUB

SUB PromptLineOff (row, column)
	PRINT
	VIEW PRINT StartLine TO EndLine
	COLOR Foreground, Background, Border
	LOCATE row, column
	COM(ComPort) ON
END SUB

SUB PromptLineOn (row, column)
	column = POS(0)
	row = CSRLIN
	COM(ComPort) STOP
	LOCATE 25, 1
	VIEW PRINT 25 TO 25
	COLOR PromptLineText, PromptLineBackground
	PRINT
END SUB

SUB QuitPrompt (r, col)
	CALL PromptLineOn(r, col)
	PRINT " press any key to quit help";
	DO
		IF Switch THEN EXIT DO
	LOOP WHILE INKEY$ = ""
	CALL PromptLineOff(r, col)
END SUB

SUB RestoreCommandScreen
DEF SEG = &HB800
	FOR i = 12000 TO 15999
		POKE i, CommandScreenbuffer(i)
	NEXT i
	DEF SEG
END SUB

SUB RestoreFileScreen
DEF SEG = &HB800
	FOR i = 8000 TO 11999
		POKE i, FileScreenbuffer(i)
	NEXT i
DEF SEG
END SUB

SUB RestoreScreen
	SELECT CASE ScreenMode
		CASE IS = 1     'TerminalScreen
			DEF SEG = &HB800
			FOR i = 4000 TO 7999
				POKE i, TerminalScreenbuffer(i)
			NEXT i
		CASE IS = 2     'FileScreen
			DEF SEG = &HB800
			FOR i = 8000 TO 11999
				POKE i, FileScreenbuffer(i)
			NEXT i
		CASE IS = 3     'Main (Command) Screen
			DEF SEG = &HB800
			FOR i = 12000 TO 15999
				POKE i, CommandScreenbuffer(i)
			NEXT i
	END SELECT
	DEF SEG
END SUB

SUB RestoreTerminalScreen
DEF SEG = &HB800
	FOR i = 4000 TO 7999
		POKE i, TerminalScreenbuffer(i)
	NEXT i
	DEF SEG
END SUB

SUB RS232
	STATIC TerminalScreenRow, TerminalScreenColumn
	STATIC FileScreenRow, FileScreenColumn
	STATIC MainScreenRow, MainScreenColumn
	STATIC RS232String$
      
	foregroundcolumn = POS(0)
	foregroundrow = CSRLIN
	IF ScreenMode = 1 THEN
		RS232ScreenColumn = TerminalScreenColumn
		RS232ScreenRow = TerminalScreenRow
	ELSEIF ScreenMode = 2 THEN
		RS232ScreenColumn = FileScreenColumn
		RS232ScreenRow = FileScreenRow
	ELSEIF ScreenMode = 3 THEN
		RS232ScreenColumn = MainScreenColumn
		RS232ScreenRow = MainScreenRow
	END IF
	IF RS232ScreenColumn < Split + 2 THEN
		RS232ScreenColumn = Split + 2
	END IF
	IF RS232ScreenRow < CSRLIN THEN
		RS232ScreenRow = CSRLIN
	END IF
       
	IF RS232ScreenRow < StartLine THEN
		RS232ScreenRow = StartLine
	ELSEIF RS232ScreenRow > EndLine THEN
		RS232ScreenRow = EndLine
	END IF
	LOCATE RS232ScreenRow, RS232ScreenColumn
	DO WHILE NOT EOF(RS232File)
	   RS232String$ = RS232String$ + INPUT$(LOC(RS232File), #RS232File)
	LOOP
	CharCount = LEN(RS232String$)
	FOR n = 1 TO CharCount
	    next$ = LEFT$(RS232String$, 1)
	    RS232String$ = RIGHT$(RS232String$, LEN(RS232String$) - 1)
	    SELECT CASE next$
		   CASE CarriageReturn$
			LOCATE , Split + 2
		   CASE LineFeed$
			RS232ScreenColumn = POS(0)
			PRINT                                   '**
			LOCATE , RS232ScreenColumn
		   CASE " " TO "~"
			PRINT next$;
		   CASE ELSE
			PRINT "["; HEX$(ASC(next$)); "]";
	    END SELECT
	    IF POS(0) < Split + 2 THEN
			PRINT
			LOCATE , Split + 2
	    END IF
	NEXT n
	IF ScreenMode = 2 THEN
		FileScreenColumn = POS(0)
		FileScreenRow = CSRLIN
	ELSEIF ScreenMode = 1 THEN
		TerminalScreenColumn = POS(0)
		TerminalScreenRow = CSRLIN
	END IF
	IF CSRLIN >= EndLine THEN
		'COLOR VerticalBar
		LOCATE EndLine, Split
		'PRINT SplitChar$;
		'COLOR Foreground
		CALL SplitPrint
	END IF
	LOCATE foregroundrow, foregroundcolumn
END SUB

SUB SaveCommandScreen
	DEF SEG = &HB800
	FOR i = 12000 TO 15999
		CommandScreenbuffer(i) = PEEK(i)
	NEXT i
	DEF SEG

END SUB

SUB SaveFileScreen
	DEF SEG = &HB800
	FOR i = 8000 TO 11999
		FileScreenbuffer(i) = PEEK(i)
	NEXT i
	DEF SEG
END SUB

SUB SaveLineOn
    column = POS(0)
    row = CSRLIN
    VIEW PRINT 1 TO 1
    COLOR CommandLineBold, CommandLineBackground
    PRINT "    "; CHR$(24); "    "; CHR$(25);
    COLOR CommandLineText: PRINT "    ";
    COLOR CommandLineBold
    PRINT CHR$(27); "    "; CHR$(26); : COLOR CommandLineText: PRINT "    ";
    COLOR CommandLineBold
    PRINT "U"; : COLOR CommandLineText: PRINT "p    ";
    COLOR CommandLineBold
    PRINT "D"; : COLOR CommandLineText: PRINT "own          ";
    COLOR CommandLineBold: PRINT "                           <Esc>    ";
    VIEW PRINT StartLine TO EndLine
    COLOR Foreground, Background, Border
    LOCATE row, column
END SUB

SUB SaveScreen
	SELECT CASE ScreenMode
		CASE IS = 1     'TerminalScreen
			DEF SEG = &HB800
			FOR i = 4000 TO 7999
				TerminalScreenbuffer(i) = PEEK(i)
			NEXT i
		CASE IS = 2     'FileScreen
			DEF SEG = &HB800
			FOR i = 8000 TO 11999
				FileScreenbuffer(i) = PEEK(i)
			NEXT i
		CASE IS = 3     'Main (Command) Screen
			DEF SEG = &HB800
			FOR i = 12000 TO 15999
				CommandScreenbuffer(i) = PEEK(i)
			NEXT i
	END SELECT
	DEF SEG
END SUB

SUB SaveScreenDisplay
	COLOR Foreground, Background
	CLS
	CALL SplitScreen
	LOCATE 3, 1
	PRINT "   Use the LEFT or RIGHT ARROW keys to move"
	PRINT " the vertical bar that divides your input"
	PRINT " and the response from the CN0170."
	PRINT "   Use the up/down cursors to choose the item"
	PRINT " you wish to change the color of."
	PRINT "   Use the 'U' or 'D' keys to change the color."
	PRINT " The window displays the # for each parameter."
	CALL DisplayCursorsLnR
	CALL SaveLineOn
END SUB

SUB SaveTerminalScreen
DEF SEG = &HB800
	FOR i = 4000 TO 7999
		TerminalScreenbuffer(i) = PEEK(i)
	NEXT i
	DEF SEG
END SUB

SUB ScreenSetup STATIC
    oldBackground = Background
    oldForeground = Foreground
    oldsplit = Split
    startrow = 11
    startcolumn = 4
    length = 13
    girth = 34
      
    CALL SaveScreenDisplay
    CALL ColorScreenWindow(startrow, startcolumn, length, girth)
    CALL Cursor(index, index, startrow, startcolumn)
    DO
      CALL GetKey(Key$)
      ExtendedCode = ASC(Key$)
      SELECT CASE Key$
	 CASE IS = "U"
	      IF ColorPalette(index) <= 14 THEN
		 ColorPalette(index) = ColorPalette(index) + 1
	      ELSE
		 ColorPalette(index) = 0
	      END IF
	      CALL SetColors
	      CALL SaveScreenDisplay
	      CALL ColorScreenWindow(startrow, startcolumn, length, girth)
	      CALL Cursor(index, index, startrow, startcolumn)
	 CASE IS = "D"
	      IF ColorPalette(index) >= 1 THEN
		 ColorPalette(index) = ColorPalette(index) - 1
	      ELSE
		 ColorPalette(index) = 15
	      END IF
	      CALL SetColors
	      CALL SaveScreenDisplay
	      CALL ColorScreenWindow(startrow, startcolumn, length, girth)
	      CALL Cursor(index, index, startrow, startcolumn)
	 CASE IS = CursorLeft$
	      COLOR Foreground, Background
	      CALL MoveVerticalBar(Split, Split - 1)
	      CALL DisplayCursorsLnR
	      CALL SaveLineOn
	 CASE IS = CursorRight$
	      COLOR Foreground, Background
	      CALL MoveVerticalBar(Split, Split + 1)
	      CALL DisplayCursorsLnR
	      CALL SaveLineOn
	 CASE IS = CursorDown$
	      IF index <= 9 THEN
		 index = index + 1
		 CALL Cursor(index - 1, index, startrow, startcolumn)
	      ELSE
		 index = 0
		 CALL Cursor(10, index, startrow, startcolumn)
	      END IF
	 CASE IS = CursorUp$
	      IF index >= 1 THEN
		 index = index - 1
		 CALL Cursor(index + 1, index, startrow, startcolumn)
	      ELSE
		 index = 10
		 CALL Cursor(0, index, startrow, startcolumn)
	      END IF
	 CASE IS = quit$
	      EXIT DO
	 CASE ELSE
	      BEEP
      END SELECT
    LOOP
    newsplit = Split
    FOR n = 1 TO 3
		SCREEN 0, 1, n, n
		COLOR Foreground, Background
		CALL MoveVerticalBar(oldsplit, newsplit)
    NEXT n
    FOR n = 0 TO 10
	PUT ParameterFile, n + 1, ColorPalette(n)
    NEXT n
    PUT ParameterFile, 14, Split
    FOR n = 1 TO 24
	PRINT
	CALL SplitScreen
    NEXT n
END SUB

SUB SendInstruction (Count, Filename$, Instruction$)
	timeout = 0
	IF FileError THEN
	   CALL OpenFile(Count, Filename$)
	ELSE
	   FOR i = 1 TO LEN(Instruction$)
		DO
		   FileError = 0
		   PRINT #RS232File, MID$(Instruction$, i, 1);
		   IF FileError THEN
			timeout = timeout + 1
			CALL PromptLineOn(row, column)
			PRINT " CTS timeout"; timeout;
			PRINT ".. retrying.. press any key to quit ";
			PRINT "(on next timeout)";
			CALL FileLineOff
			IF INKEY$ <> "" THEN EXIT SUB
		   END IF
		LOOP UNTIL FileError = 0
	   NEXT i
	   PRINT #RS232File,
	   IF timeout THEN
		CALL PromptLineOn(row, column)
		PRINT " press any key to interrupt operation";
		CALL FileLineOff
	   END IF
	END IF
END SUB

SUB SetBaud
   STATIC NotFirstPass, RS232File$
  
   CLOSE RS232File
   PRINT : PRINT : PRINT
   IF NotFirstPass THEN
	CALL SplitScreen
   ELSE
	RS232File$ = ComPort$ + Baud$ + ",N,8,1,CS10000,DS10000"
   END IF
TryAgain:
   IF NotFirstPass THEN CALL SplitScreen
   PRINT " ENTER COM PORT #   (or just <Enter> for "; ComPort$; ")";
   LINE INPUT ; INCOMM$
   IF INCOMM$ = "1" THEN
	ComPort$ = "COM1:"
   ELSEIF INCOMM$ = "2" THEN
	ComPort$ = "COM2:"
   END IF
   PRINT
   IF NotFirstPass THEN CALL SplitScreen
   PRINT " ENTER BAUD RATE    (or just <Enter> for "; Baud$; ")";
   LINE INPUT ; INBAUD$
   SELECT CASE INBAUD$
	CASE "300"
		Baud$ = INBAUD$
	CASE "600"
		Baud$ = INBAUD$
	CASE "1200"
		Baud$ = INBAUD$
	CASE "2400"
		Baud$ = INBAUD$
	CASE "4800"
		Baud$ = INBAUD$
	CASE "9600"
		Baud$ = INBAUD$
   END SELECT
   TempRS232File$ = ComPort$ + Baud$ + ",N,8,1,CS10000,DS10000"
   column = POS(0)
   row = CSRLIN
   LOCATE 25, 1
   VIEW PRINT 25 TO 25
   COLOR PromptLineText, PromptLineBackground
   PRINT : PRINT " press <Esc> to quit";
   VIEW PRINT StartLine TO EndLine
   COLOR Foreground, Background, Border
   LOCATE row, column
   PRINT : PRINT : PRINT " "; TempRS232File$: PRINT
   PRINT " <Enter> TO CONFIRM or ANYTHING ELSE TO REVIEW"
   IF NotFirstPass THEN CALL SplitScreen
   CALL GetKey(Key$)
   IF Key$ = quit$ THEN
	OPEN RS232File$ FOR RANDOM AS RS232File LEN = 2048
	EXIT SUB
   END IF
   IF Key$ <> CarriageReturn$ THEN GOTO TryAgain
   PRINT : PRINT " POWER-UP CN0170(S), PRESS RETURN"
   IF NotFirstPass THEN CALL SplitScreen
   CALL GetKey(Key$)
   IF Key$ = quit$ THEN
	OPEN RS232File$ FOR RANDOM AS RS232File LEN = 2048
	EXIT SUB
   END IF
   PRINT
   IF NotFirstPass THEN CALL SplitScreen
   ComPort = VAL(RIGHT$(ComPort$, 2))
   COM(ComPort) OFF
   RS232File$ = TempRS232File$
   OPEN RS232File$ FOR RANDOM AS RS232File LEN = 2048
   COM(ComPort) ON
   ON COM(ComPort) GOSUB Receiver
   PRINT #RS232File, CarriageReturn$                       'send CR to CN0170
   PRINT
   PRINT " BAUD RATE SET"
   PRINT
   IF NotFirstPass THEN CALL SplitScreen
   NotFirstPass = 1
   PUT ParameterFile, 12, ComPort$
   PUT ParameterFile, 13, Baud$
END SUB

SUB SetColors
	CommandLineBold = ColorPalette(0)
	CommandLineText = ColorPalette(1)
	CommandLineBackground = ColorPalette(2)
	Foreground = ColorPalette(3)
	Background = ColorPalette(4)
	WindowText = ColorPalette(5)
	WindowBackground = ColorPalette(6)
	VerticalBar = ColorPalette(7)
	PromptLineText = ColorPalette(8)
	PromptLineBackground = ColorPalette(9)
	Border = ColorPalette(10)
END SUB

SUB SetDate
   D$ = DATE$
   M$ = MID$(D$, 1, 2)
   DAYS$ = MID$(D$, 4, 2)
   Y$ = MID$(D$, 9, 2)
   DATESET$ = "D=" + M$ + "/" + DAYS$ + "/" + Y$
   PRINT #RS232File, DATESET$
   PRINT " DATE SET"
END SUB

SUB SetTime
   t$ = TIME$
   HM$ = MID$(t$, 1, 5)
   S$ = MID$(t$, 7, 2)
   TIMESET$ = "T=" + HM$ + "." + S$
   PRINT #RS232File, TIMESET$
   PRINT " TIME SET"
END SUB

SUB SplitPrint
	IF CSRLIN <= EndLine THEN
		column = POS(0)
		LOCATE , Split
		COLOR VerticalBar
		PRINT SplitChar$;
		COLOR Foreground
		LOCATE , column
	END IF
END SUB

SUB SplitScreen
	COM(ComPort) STOP
	column = POS(0)
	row = CSRLIN
	COLOR VerticalBar
	FOR i = EndLine TO StartLine STEP -1
		LOCATE i, Split
		PRINT SplitChar$;
	NEXT i
	COLOR Foreground
	COM(ComPort) ON
	LOCATE row, column
END SUB

SUB TERMINAL
	STATIC row, column
     
	ScreenMode = 1
	SCREEN 0, 1, ScreenMode, ScreenMode
	CALL TerminalLineOn
	CALL SplitScreen
	IF row < StartLine THEN row = StartLine
	IF column < 1 THEN column = 1
	LOCATE row, column
	Key$ = ""
	limit = 1
	DO
		CALL GetString(Key$, InputString$, limit)
		IF Key$ = quit$ THEN EXIT DO
		DO
			IF Key$ = repeat$ THEN PRINT InputString$;
			PRINT #RS232File, InputString$;       'send to CN0170
			CALL SplitPrint
			CALL GetKey(Key$)
		LOOP UNTIL Key$ <> repeat$
	LOOP UNTIL Key$ = quit$
	Key$ = ""
	column = POS(0)
	row = CSRLIN
END SUB

SUB TerminalHelp
	CALL SaveTerminalScreen
	column = POS(0)
	row = CSRLIN
	startrow = 4
	startcolumn = 15
	length = 12
	girth = 62
	CALL TerminalLineOff
	CALL OpenWindow(startrow, startcolumn, length, girth)
	LOCATE startrow + 2, startcolumn + 4
	PRINT "Type instruction(s) for CN0170 and press <Enter>";
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "  (any response from the CN0170 will appear in the";
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "   window to the right of the vertical divider).";
	LOCATE CSRLIN + 2, startcolumn + 4
	PRINT "<Alt>R   repeats the last instruction";
	LOCATE CSRLIN + 2, startcolumn + 4
	PRINT "<F6>     switches from TERMINAL to FILE directly";
	LOCATE CSRLIN + 1, startcolumn + 4
	PRINT "<Esc>    (or <Alt>Q) to leave Terminal mode.";
	CALL QuitPrompt(r, col)
	LOCATE row, column
	CALL RestoreTerminalScreen
END SUB

SUB TerminalLineOff
	VIEW PRINT 1 TO 1
	COLOR CommandLineText, CommandLineBackground
	PRINT "    <Alt>R";
	PRINT "epeat    ";
	PRINT "                            F6=Switch    F1";
	PRINT "=Help    ";
	PRINT "<Esc>    ";
	CALL PromptLineOn(r, c)
	PRINT
	COLOR Foreground, Background, Border
	VIEW PRINT StartLine TO EndLine
END SUB

SUB TerminalLineOn
	VIEW PRINT 1 TO 1
	COLOR CommandLineBold, CommandLineBackground
	PRINT "    <Alt>R";
	COLOR CommandLineText
	PRINT "epeat    ";
	COLOR CommandLineBold
	PRINT "                            F6";
	COLOR CommandLineText
	PRINT "=Switch    ";
	COLOR CommandLineBold
	PRINT "F1";
	COLOR CommandLineText
	PRINT "=Help    ";
	COLOR CommandLineBold
	PRINT "<Esc>    ";
	CALL PromptLineOn(r, c)
	PRINT
	COLOR Foreground, Background, Border
	VIEW PRINT StartLine TO EndLine
END SUB

